/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.pa.RunnableSysmonStart;
import com.ibm.hwmca.fw.pa.config.EventGeneratorData;
import com.ibm.hwmca.fw.pa.config.EventManagerData;
import com.ibm.hwmca.fw.pa.config.ProblemAnalysisData;
import com.ibm.hwmca.fw.pa.config.ProblemAnalysisXMLParser;
import com.ibm.hwmca.fw.pa.config.RemoteSystemProviderData;
import com.ibm.hwmca.fw.pa.config.RemoteSystemProvidersData;
import com.ibm.hwmca.fw.pa.event.EventPersistence;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventGenerator;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblemListener;
import com.ibm.hwmca.xfw.pa.problem.DistributedProblemReplicator;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class ProblemAnalysisManager {
    private static final String TRACE_MASKT = "XPAFARMT";
    private static final String TRACE_MASKF = "XPAFARMF";
    private static final String TRACE_MASKD = "XPAFARMD";
    private static ProblemAnalysisManager manager = null;
    private static Class[] EVENT_GENERATOR_SIGNATURE = new Class[]{class$com$ibm$hwmca$fw$pa$config$EventGeneratorData == null ? (class$com$ibm$hwmca$fw$pa$config$EventGeneratorData = ProblemAnalysisManager.class$("com.ibm.hwmca.fw.pa.config.EventGeneratorData")) : class$com$ibm$hwmca$fw$pa$config$EventGeneratorData, class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEventManager == null ? (class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEventManager = ProblemAnalysisManager.class$("com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager")) : class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEventManager};
    private static String CONFIG_FILE_PREFIX = "config_";
    private static String CONFIG_FILE_SUFFIX = ".xml";
    private static Object initLock = new Object();
    private static boolean initialized = false;
    private Map rsProviders = new HashMap();
    private Map eventManagers = new HashMap();
    private Map eventGenerators = new HashMap();
    private EventPersistence eventPersistence = null;
    private ArrayList specialRefcodes = new ArrayList();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$pa$config$EventGeneratorData;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEventManager;

    public static synchronized ProblemAnalysisManager getProblemAnalysisManager() {
        if (manager == null) {
            manager = new ProblemAnalysisManager();
        }
        return manager;
    }

    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object rt;
        Trace.trace(TRACE_MASKD, "PA init running.");
        try {
            String baseFilePath = BaseFileControl.getFilePath("paconfig");
            Trace.trace(TRACE_MASKD, "Looking in '" + baseFilePath + "' for PA config files.");
            boolean pmListenersInitialized = false;
            File[] configFiles = new File(baseFilePath).listFiles(new FileFilter());
            for (int i = 0; i < configFiles.length; ++i) {
                try {
                    Trace.trace(TRACE_MASKD, "Processing config file '" + configFiles[i].getCanonicalPath() + "'.");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKD, "Processing config file '" + configFiles[i] + "'.");
                }
                try {
                    ProblemAnalysisData paData = ProblemAnalysisXMLParser.parseXML(configFiles[i]);
                    this.setSpecialRefcodes(paData.getSpecialRefcodes());
                    Iterator<Object> iterator = null;
                    RemoteSystemProvidersData rspsData = paData.getRemoteSystemProvidersData();
                    if (rspsData != null) {
                        Map rspDatas = rspsData.getRemoteSystemProviderDatas();
                        iterator = rspDatas.keySet().iterator();
                        String rspName = null;
                        while (iterator.hasNext()) {
                            rspName = (String)iterator.next();
                            Trace.trace(TRACE_MASKD, "Processing RemoteSystemProvider '" + rspName + "'.");
                            if (!this.rsProviders.containsKey(rspName)) {
                                RemoteSystemProviderData rspData = (RemoteSystemProviderData)rspDatas.get(rspName);
                                try {
                                    this.rsProviders.put(rspData.getName(), rspData.constructAssociatedClassInstance());
                                }
                                catch (HException he) {
                                    Trace.trace(TRACE_MASKT, "Exception constructing provider.  Ignoring provider.");
                                    Trace.trace(TRACE_MASKT, he);
                                }
                                continue;
                            }
                            Trace.trace(TRACE_MASKD, "Warning: Duplicate RemoteSystemProvider '" + rspName + "' being ignored.");
                        }
                    }
                    try {
                        RemoteSystemManager.configureRemoteSystemManager(paData.getRemoteSystemManagerData(), this.rsProviders);
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKT, "Warning: Attempt to configure to RemoteSystemManager failed, being ignored:" + e.getMessage());
                    }
                    try {
                        ProblemManager.setConfigData(paData.getPersistenceData().getProblemManagerData());
                        if (!pmListenersInitialized) {
                            ProblemManager pm = ProblemManager.getProblemManager();
                            pm.registerListenersBeforeCPL();
                            pm.addPropertyChangeListener(new CommonProblemListener());
                            pm.registerListenersAfterCPL();
                            pm.addPropertyChangeListener(DistributedProblemReplicator.getDistributedProblemReplicator());
                            pmListenersInitialized = true;
                        }
                    }
                    catch (PersistenceNotInitializedException e) {
                        Trace.trace(TRACE_MASKF, "Warning: Attempt to add config data to ProblemManager failed, being ignored:" + e.getMessage());
                    }
                    iterator = paData.getEventManagers().iterator();
                    while (iterator.hasNext()) {
                        EventManagerData eventManagerData = (EventManagerData)iterator.next();
                        Trace.trace(TRACE_MASKD, "Processing manager '" + eventManagerData.getName() + "'.");
                        if (!this.eventManagers.containsKey(eventManagerData.getName())) {
                            this.eventManagers.put(eventManagerData.getName(), new ProblemAnalysisEventManager(eventManagerData, this.eventPersistence));
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "Warning: Duplicate event manager '" + eventManagerData.getName() + "' being ignored.");
                    }
                    Map generators = paData.getEventGeneratorsData().getEventGenerators();
                    iterator = generators.keySet().iterator();
                    while (iterator.hasNext()) {
                        String genName = (String)iterator.next();
                        Trace.trace(TRACE_MASKD, "Processing generator '" + genName + "'.");
                        if (!this.eventGenerators.containsKey(genName)) {
                            EventGeneratorData data = (EventGeneratorData)generators.get(genName);
                            ProblemAnalysisEventManager manager = (ProblemAnalysisEventManager)this.eventManagers.get(data.getManagerName());
                            if (manager != null) {
                                try {
                                    Constructor<?> constructor = Class.forName(data.getClassName()).getConstructor(EVENT_GENERATOR_SIGNATURE);
                                    this.eventGenerators.put(genName, (ProblemAnalysisEventGenerator)constructor.newInstance(data, manager));
                                }
                                catch (ClassNotFoundException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: ClassNotFoundException for event generator '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                catch (NoSuchMethodException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: NoSuchMethodException for event generator constructor '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                catch (SecurityException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: SecurityException for event generator '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                catch (InstantiationException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: InstantiationException for event generator '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                catch (IllegalAccessException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: IllegalAccessException for event generator '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                catch (InvocationTargetException e) {
                                    Trace.trace(TRACE_MASKF, "Warning: InvocationTargetException for event generator '" + data.getClassName() + "', ignoring.");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "Warning: event generator '" + genName + "' references unknown manager '" + data.getManagerName() + "', ignoring.");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "Warning: Duplicate event generator '" + genName + "' being ignored.");
                    }
                    continue;
                }
                catch (MalformedXMLException e) {
                    Trace.trace(TRACE_MASKF, "Init receives MalformedXMLException on '" + configFiles[i] + "', ignoring.  Msg=" + e.getMessage());
                    Trace.trace(TRACE_MASKF, e);
                }
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Init receives HException." + ProblemAnalysisManager.getStackTrace(e));
        }
        String devel = System.getProperty("DEVELOPMENT_SYSTEM");
        Trace.trace(TRACE_MASKD, "devel= " + devel);
        Properties prop = System.getProperties();
        Enumeration<?> names = prop.propertyNames();
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            Trace.trace(TRACE_MASKT, propName + " = " + prop.get(propName));
        }
        if (devel == null || devel != null && !devel.equalsIgnoreCase("YES")) {
            Trace.trace(TRACE_MASKT, "--> runSysLogMonitor ");
            rt = new RunnableSysmonStart();
            ((RunnableSysmonStart)rt).Start();
        } else {
            Trace.trace(TRACE_MASKT, "DEVELOPMENT Environment no start of sysmonWTokenParser ");
        }
        rt = initLock;
        synchronized (rt) {
            initialized = true;
            initLock.notifyAll();
        }
        Log theLog = new Log(-86, 70, 0, "PA INIT DONE", null, null, null, null);
        String dataString = "Problem analysis completed initialzation";
        theLog.add((byte)3, dataString);
        theLog.log();
        Trace.trace(TRACE_MASKD, "PA init ends.");
    }

    private ProblemAnalysisManager() {
        this.init();
    }

    public Map getRemoteSystemProviders() {
        return this.rsProviders;
    }

    public Map getEventManagers() {
        return this.eventManagers;
    }

    public Map getEventGenerators() {
        return this.eventGenerators;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForInitialization() {
        Object object = initLock;
        synchronized (object) {
            while (!initialized) {
                try {
                    initLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void main(String[] args) {
        boolean needInit = true;
        try {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("noinit")) continue;
                    System.out.println("no init....");
                    needInit = false;
                }
            }
            if (needInit) {
                Class<?> nbClass = Class.forName("com.ibm.hwmca.fw.bridge.NativeBridgeServer$Init");
                Runnable nbObj = (Runnable)nbClass.newInstance();
                nbObj.run();
                System.out.println("NativeBridgeServer running...");
                Class<?> isClass = Class.forName("com.ibm.hwmca.base.system.InitServices");
                Runnable isObj = (Runnable)isClass.newInstance();
                isObj.run();
                System.out.println("InitServices running...");
                Class<?> dmClass = Class.forName("com.ibm.hwmca.fw.domain.DomainManager$Init");
                Runnable dmObj = (Runnable)dmClass.newInstance();
                dmObj.run();
                System.out.println("DomainManager running...");
                Class<?> paClass = Class.forName("com.ibm.hwmca.fw.pa.ProblemAnalysisManager$Init");
                Runnable paObj = (Runnable)paClass.newInstance();
                paObj.run();
                System.out.println("ProblemAnalysisManager running...");
            }
            if (args != null) {
                boolean doLog = false;
                byte logClass = -86;
                byte logType = 50;
                short user = -8531;
                String name = "PA Test";
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("class=")) {
                        logClass = (byte)Integer.valueOf(args[i].substring(6), 16).intValue();
                        doLog = true;
                        continue;
                    }
                    if (args[i].startsWith("type=")) {
                        logType = (byte)Integer.valueOf(args[i].substring(5), 16).intValue();
                        doLog = true;
                        continue;
                    }
                    if (args[i].startsWith("user=")) {
                        user = (short)Integer.valueOf(args[i].substring(5), 16).intValue();
                        doLog = true;
                        continue;
                    }
                    if (!args[i].startsWith("name=")) continue;
                    name = args[i].substring(5);
                    doLog = true;
                }
                if (doLog) {
                    System.out.println("logging event...");
                    Log theLog = new Log(logClass, logType, user, name, null, null, null, null);
                    theLog.log(LogAttributes.ERROR_LOG);
                }
            }
            System.out.println("...done");
            while (true) {
                // Infinite loop
            }
        }
        catch (Exception e) {
            System.out.println("ProblemAnalysisManager:Main:Exception: " + e);
            e.printStackTrace();
            return;
        }
    }

    public ArrayList getSpecialRefcodes() {
        return this.specialRefcodes;
    }

    protected void setSpecialRefcodes(ArrayList list) {
        this.specialRefcodes = list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Init
    implements Runnable {
        private static ProblemAnalysisManager manager = null;

        public void run() {
            manager = ProblemAnalysisManager.getProblemAnalysisManager();
        }
    }

    static class FileFilter
    implements FilenameFilter {
        FileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(CONFIG_FILE_PREFIX) && name.endsWith(CONFIG_FILE_SUFFIX);
        }
    }
}

